getwd()
setwd(dirname(rstudioapi::getActiveDocumentContext()$path))

## Packages
set.seed(717)
library(cubature)
library(lava) 
library(ggplot2)
library(mcGlobaloptim) 
library(DiceKriging) 
library(nloptr) 
library(MASS)
library(mcmc)
library(geoR)
library(RobustCalibration)
library(lhs)
library(RobustGaSP)
library(numDeriv)
library(ggplot2)
library(rTensor)
library(plotly)
library(R.matlab)
library(proxy)
library(abind)
library(scatterplot3d)
library(Matrix)
library(purrr)
library(plyr)
library(multiway)

# tempdir()
# dir.create(tempdir())
load("c1-setting.RData")

data <- readMat("data1.mat")$data

data.inx <- data[,1:3]
data.x <- data[,4:5]
data.y <- data[,6]

dim.f = c(4,4,3)
d = 2; lower.x = apply(data.x,2,min); upper.x = apply(data.x,2,max)

dim.s = c(2,2,2)
dim.h = prod(dim.s); dim.mode = length(dim.s)

k = 1; N = nrow(data.x)

h <- function(y) sum(y)
true.model<-function(y) sum(sort(y, decreasing = TRUE)[1:k])

y0 = array(NA, c(dim.f,N))
for(i in 1:N) y0[data.inx[i,1],data.inx[i,2],data.inx[i,3],i] = data.y[i]

ind.x.star = which.max(apply(y0,dim.mode+1,true.model))
h.star = apply(y0,dim.mode+1,true.model)[ind.x.star]
ind.star = arrayInd(order(y0[,,,ind.x.star], decreasing = TRUE)[1:k],dim.f)
ora.x.star = data.x[ind.x.star,]

ind.x.star; h.star; ind.star



## Kernel
norm0 <- function(x1,x2) as.matrix(dist(x1,x2,method = "Euclidean"))
norm1 <- function(x1,x2){
  nor = list()
  for(i in 1:d){
    nor[[i]] = norm0(x1[,i],x2[,i])}
  return(nor)
} 

mat0 <- function(x) matern(x, phi=1, kappa=5/2)
gau0 <- function(x) exp(-x^2)
exp0 <- function(x) exp(-abs(x))

ker.sele <- function(x1,x2,theta,ker){
  x = norm1(x1,x2)
  dis = Map(function(x0,th) x0/th,x,theta)
  R0 = Map(function(x0) ker(x0),dis)
  R = Reduce("*", R0)
  return(R)
}

noise <- function(x1,x2){
  no.ind = which(apply(x1, 1, function(row_a) apply(x2, 1, function(row_b) all(row_a == row_b))), arr.ind = TRUE)
  no.0 = matrix(0,nrow(x2),nrow(x1))
  no.0[no.ind] = 1
  return(t(no.0))
}

B.tuck.mt <- function(y,ind,n){
  y_0 = array(NA,dim=c(dim.f,n))
  
  for (i in 1:n) {
    for(j in 1:k){
      idx <- ind[[i]]
      y_0[idx[j,1],idx[j,2],idx[j,3],i] = y[j,i]
    }
  }
  
  tuck.re = multiway::tucker(y_0, nfac = c(dim.s,n), nstart = 1, Dfixed = diag(n))
  U.tuck = list(tuck.re$C,tuck.re$B,tuck.re$A)
  core.ten = tuck.re$G
  
  return(list(core.ten=core.ten, U.tuck=U.tuck))
}

pos <- function(ind) array(1:prod(dim.f),dim.f)[ind]

e.ind <- function(ind){
  e0 = pos(ind); ord = cbind(1:k,e0)
  e.re = matrix(0,k,prod(dim.f))
  e.re[ord] = 1
  return(e.re)
}


################################################################################
#### GP ########################################################################
################################################################################

################################################################################
## Our proposed method: NS-mtGP
vec.lab = list()
vec.lab[[1]] = dim.h*(dim.h+1)/2
vec.lab[[2]] = d
vec.lab[[3]] = vec.lab[[4]] = 1
group.lab <- unlist(Map(rep, LETTERS[1:length(vec.lab)], unlist(vec.lab)))
dim.hyper.mt = length(group.lab)

lower.th = c(unlist(Map(rep, c(1e-3,1e-3,1e-2,1e-10), unlist(vec.lab))))
upper.th = c(unlist(Map(rep, c(1,10,10,1e-2), unlist(vec.lab))))

sig.mt <- function(t,ome){
  O = matrix(0,t,t)
  O[lower.tri(O, diag = T)] <- ome
  return(O)
}

likeli.mt <- function(x1,x2,y,ind,n,t0,the,B.tuck){
  the0 = split(the, group.lab)
  
  k.ini = the0[[3]]*ker.sele(x1,x2,the0[[2]],mat0)+the0[[4]]*noise(x1,x2)
  omega = sig.mt(t0,the0[[1]])%*%t(sig.mt(t0,the0[[1]]))
  k.y = kronecker(k.ini,omega)
  
  e.ini = as.matrix(bdiag(lapply(ind,function(ind) e.ind(ind)%*%B.tuck)))
  par.tuck.k.y = e.ini%*%k.y%*%t(e.ini)
  sol.par.tuck.k.y = ginv(par.tuck.k.y)
  
  log.likeli = determinant(par.tuck.k.y,logarithm=TRUE)$modulus+
    t(c(y))%*%sol.par.tuck.k.y%*%c(y)
  return(list(like=log.likeli, the0=the0))
}
# likeli.mt(x,x,y0.par.tuck,k.ind,n,dim.h,runif(dim.hyper.mt))


mtgp.hat <- function(x.new,ind.new,x,y,ind,n,n.test,t0,hy,B.tuck){
  x.new = matrix(x.new,n.test,d)
  omega = sig.mt(t0,hy[[1]])%*%t(sig.mt(t0,hy[[1]]))
  
  e.ini = as.matrix(bdiag(lapply(ind,function(ind) e.ind(ind)%*%B.tuck)))
  
  k.mt.s0 = hy[[3]]*ker.sele(x,x,hy[[2]],mat0)+hy[[4]]*noise(x,x)
  k.y = e.ini%*%kronecker(k.mt.s0,omega)%*%t(e.ini)
  sol.k.y = ginv(k.y)
  
  k.mt.10 = hy[[3]]*ker.sele(x.new,x,hy[[2]],mat0)+hy[[4]]*noise(x.new,x)
  k.mt.1 = kronecker(k.mt.10,omega)%*%t(e.ini)
  
  k.mt.00 = hy[[3]]*ker.sele(x.new,x.new,hy[[2]],mat0)+hy[[4]]*noise(x.new,x.new)
  k.mt.0 = kronecker(k.mt.00,omega)
  
  #based on tucker
  k.oth.tuck = k.mt.1%*%sol.k.y #p*nq
  
  f.hat.tuck = k.oth.tuck%*%c(y) #p*1
  var.hat.tuck = hy[[2]][1]*(k.mt.0-k.oth.tuck%*%t(k.mt.1)) #p*p
  
  result = list(mean.tuck = f.hat.tuck, cov.tuck = var.hat.tuck)
  return(result)
}


EIJ <- function(i,j){
  E0 = matrix(0,dim.h,dim.h); E0[i,j] = 1
  return(E0)
}

der.l <- function(x1,x2,y,ind,n,the,B.tuck){
  the0 = split(the, group.lab)
  ome = the0[[1]]; th = the0[[2]]; sig2 = the0[[3]]; tau2 = the0[[4]]
  
  J <- function(i){
    E0 = matrix(0,dim.h,dim.h); E0[i,i] = exp(sig.mt(dim.h,the0[[1]])[i,i])
    return(E0)
  }
  
  k.ini0 = ker.sele(x1,x2,the0[[2]],mat0)
  k.ini = the0[[3]]*k.ini0+the0[[4]]*noise(x1,x2)
  omega = sig.mt(dim.h,the0[[1]])%*%t(sig.mt(dim.h,the0[[1]]))
  sol.o = ginv(omega)
  
  k.y = kronecker(k.ini,omega)
  
  e.ini = as.matrix(bdiag(lapply(ind,function(ind) e.ind(ind)%*%B.tuck))) #nq*np
  par.k.y = e.ini%*%k.y%*%t(e.ini)
  sol.par.k.y = ginv(par.k.y)
  
  al.k = sol.par.k.y%*%c(y)
  al.k1 = e.ini%*%kronecker(k.ini0,omega)%*%t(e.ini)
  al.k2 = e.ini%*%kronecker(diag(n),omega)%*%t(e.ini)
  der.l.sig = tr(sol.par.k.y%*%al.k1)-t(al.k)%*%al.k1%*%al.k
  der.l.tau2 = tr(sol.par.k.y%*%al.k2)-t(al.k)%*%al.k2%*%al.k
  
  der.th = array(jacobian(function(theta) ker.sele(x1,x2,theta,mat0), th),dim=c(n,n,d))
  der.l.th.i <- function(der) sig2*(tr(t(e.ini)%*%sol.par.k.y%*%e.ini%*%kronecker(der,omega))-
                                      t(al.k)%*%e.ini%*%kronecker(der,omega)%*%t(e.ini)%*%al.k)
  der.l.th = apply(der.th,3,der.l.th.i)
  
  
  der.l.phi.ij <- function(i,j) as.numeric(tr(sol.par.k.y%*%e.ini%*%kronecker(k.ini,(EIJ(i,j)%*%t(omega)+omega%*%EIJ(j,i)))%*%t(e.ini))-
                                             t(al.k)%*%e.ini%*%kronecker(k.ini,(EIJ(i,j)%*%t(omega)+omega%*%EIJ(j,i)))%*%t(e.ini)%*%al.k)
  der.l.phi.1 = sapply(c(1:dim.h), function(i) {
    sapply(c(1:i), function(j) der.l.phi.ij(i, j))
  })
  
  der.l.phi.ii <- function(i) tr(sol.par.k.y%*%e.ini%*%kronecker(k.ini,(J(i)%*%t(omega)+omega%*%J(i)))%*%t(e.ini))-
    t(al.k)%*%e.ini%*%kronecker(k.ini,(J(i)%*%t(omega)+omega%*%J(i)))%*%t(e.ini)%*%al.k
  der.l.phi.dig = apply(as.matrix(c(1:dim.h)),1, der.l.phi.ii)
  
  der.l.phi = matrix(0, dim.h, dim.h)
  for (i in 1:dim.h) {
    der.l.phi[i, 1:i] <- der.l.phi.1[[i]]
  }
  diag(der.l.phi) = der.l.phi.dig
  
  result = list(der.l.phi=der.l.phi[lower.tri(der.l.phi, diag = T)], der.l.th=der.l.th, der.l.sig=der.l.sig, der.l.tau2=der.l.tau2)
  return(result)
}
# der.l(x,x,y0.tuck,k.ind,n,runif(dim.hyper.mt))


################################################################################
## Our proposed method: NS-mtGP-UCB
n = 20; m = 50; J.for = 10
x.cand = unique(data.x)

like.re.mt = hyper.mt = fhat = lapply(1:J.for, function(x) list())
x0.mt = y0.mt = ind.x.mt = ind0.mt = list()
mtgp.bo = h.mt = list()
regret.mt = ins.regret.mt = cum.regret.mt = list()
beta.mt = alpha.mt = ucb.new.mt = lapply(1:J.for, function(x) list())
tab.ind.mt = lapply(1:J.for, function(x) list())


for(j.for.mt in 1:J.for){
  ind.x = sample(N,n); ind.x
  # ind.x = c.ini.set$ind.x.for.new[[j.for.mt]]
  x = data.x[ind.x,]; y.or = y0[,,,ind.x]
  
  k.ind = lapply(1:n, function(i) matrix(data.inx[ind.x[i],],k,dim.mode))
  y.x = alply(y.or, .margins = dim.mode+1)
  y = matrix(sapply(1:n,function(i) 
    y.or[k.ind[[i]][1],k.ind[[i]][2],k.ind[[i]][3],i]),k,n)
  
  y.tuck = B.tuck.mt(y,k.ind,n); B.tuck = Reduce(kronecker,y.tuck$U.tuck)
  # y0.0 = y.tuck$core.ten
  # y0 = abind(y0.0, along = dim.mode+1)
  
  
  ## Setting
  ######################################## BO ####################################
  hyper.mt.old = directL(function(the) likeli.mt(x,x,y,k.ind,n,dim.h,the,B.tuck)$like,lower.th,upper.th,control=list(maxeval=1000))$par
  hyper.mt.new = optim(par = hyper.mt.old, 
                       fn = function(the) likeli.mt(x,x,y,k.ind,n,dim.h,the,B.tuck)$like,
                       gr = function(the) unlist(der.l(x,x,y,k.ind,n,the,B.tuck)), 
                       method = "L-BFGS-B", lower=lower.th, upper=upper.th)$par
  
  like.re.mt[[j.for.mt]][[1]] = likeli.mt(x,x,y,k.ind,n,dim.h,hyper.mt.new,B.tuck)
  hyper.mt[[j.for.mt]][[1]] = like.re.mt[[j.for.mt]][[1]]$the0
  
  
  x0 = data.x; inx0 = c(1:N)
  x0.mt[[j.for.mt]] = x; y0.mt[[j.for.mt]] = y; ind.x.mt[[j.for.mt]] = ind.x
  n.mt = n; ind0.mt[[j.for.mt]] = k.ind
  
  x.new.mt = t(as.matrix(x[which.max(apply(y,2,h)),]))
  y.new.mt = y[,which.max(apply(y,2,h))]
  ind.new.mt = list(k.ind[[which.max(apply(y,2,h))]])
  e.new = as.matrix(bdiag(lapply(ind.new.mt,function(ind) e.ind(ind)%*%B.tuck)))
  
  hyper.mt.ucb = unlist(hyper.mt[[j.for.mt]][[1]]); delta.mt = 0.05
  fhat[[j.for.mt]][[1]] = mtgp.hat(x.new.mt,ind.new.mt,x0.mt[[j.for.mt]],y0.mt[[j.for.mt]], ind0.mt[[j.for.mt]],
                                   n.mt,1,dim.h,hyper.mt[[j.for.mt]][[1]],B.tuck)
  
  for(i.mt in 1:m){
    sig2 = hyper.mt[[j.for.mt]][[i.mt]][[2]][2]
    eta = hyper.mt[[j.for.mt]][[i.mt]][[2]][2]
    it1 = Map(function(A) determinant(diag(dim.h)+1/eta*A[[2]],logarithm=TRUE)$modulus,fhat[[j.for.mt]])
    beta.mt[[j.for.mt]][[i.mt]] = sqrt(Matrix::norm(B.tuck%*%fhat[[j.for.mt]][[1]]$mean.tuck,type="2"))+
      sqrt(sig2/eta)*sqrt(2*log(1/delta.mt)+Reduce(sum,it1))
    
    alpha.mt[[j.for.mt]][[i.mt]] = 2*log(dim.h*i.mt^2*m*6/(pi^2*delta.mt))
    
    ucb.mt <- function(x.new,beta){
      x.new = matrix(x.new,1,d)
      mtgp.output = mtgp.hat(x.new,ind.new.mt,x0.mt[[j.for.mt]],y0.mt[[j.for.mt]],ind0.mt[[j.for.mt]],
                             n.mt,n.test=1,dim.h,hyper.mt[[j.for.mt]][[i.mt]],B.tuck)
      ucb = sum(mtgp.output$mean.tuck)+beta*sqrt(Matrix::norm(mtgp.output$cov.tuck,type="2"))
      return(ucb)
    }
    
    ucb.x = apply(x.cand,1,function(x.new) -ucb.mt(x.new,beta.mt[[j.for.mt]][[i.mt]]))
    ind.x.new.mt0 = which(apply(x0[-ind.x.mt[[j.for.mt]],],1,function(x) 
      all(x == x.cand[which.min(ucb.x),])))
    ind.x.new.mt = sample(inx0[-ind.x.mt[[j.for.mt]]][ind.x.new.mt0],1)
    x.new.mt = x0[ind.x.new.mt,]; y.new.mt.0 = y0[,,,ind.x.new.mt]
    # ind.x.new.mt = sample(inx0[-ind.x.mt[[j.for.mt]]],1)
    
    
    mt.output = mtgp.hat(x.new.mt,ind.new.mt,x0.mt[[j.for.mt]],y0.mt[[j.for.mt]],ind0.mt[[j.for.mt]],n.mt,n.test=1,
                         dim.h,hyper.mt[[j.for.mt]][[i.mt]],B.tuck)
    
    ind.new.mt = list(t(as.matrix(data.inx[ind.x.new.mt,])))
    e.new = e.ind(ind.new.mt[[1]])%*%B.tuck
    y.new.mt = y.new.mt.0[ind.new.mt[[1]]]
    
    ucb.new.mt[[j.for.mt]][[i.mt]] = ucb.mt(x.new.mt,beta.mt[[j.for.mt]][[i.mt]])
    fhat[[j.for.mt]][[i.mt+1]] = mtgp.hat(x.new.mt,ind.new.mt,x0.mt[[j.for.mt]],y0.mt[[j.for.mt]],ind0.mt[[j.for.mt]],
                                          n.mt,n.test=1,dim.h,hyper.mt[[j.for.mt]][[i.mt]],B.tuck)
    
    x0.mt[[j.for.mt]] = rbind(x0.mt[[j.for.mt]], x.new.mt)
    y0.mt[[j.for.mt]] = cbind(y0.mt[[j.for.mt]], y.new.mt)
    ind.x.mt[[j.for.mt]] = c(ind.x.mt[[j.for.mt]],ind.x.new.mt)
    
    ind0.mt[[j.for.mt]] = append(ind0.mt[[j.for.mt]], ind.new.mt)
    
    n.mt = n+i.mt
    
    if(i.mt %% 150 == 0){
      hyper.mt.ucb = optim(par = unlist(hyper.mt[[j.for.mt]][[i.mt]]), 
                           fn = function(the) likeli.mt(x0.mt[[j.for.mt]],x0.mt[[j.for.mt]],y0.mt[[j.for.mt]],ind0.mt[[j.for.mt]],n.mt,dim.h,the,B.tuck)$like, 
                           gr = function(the) unlist(der.l(x0.mt[[j.for.mt]],x0.mt[[j.for.mt]],y0.mt[[j.for.mt]],ind0.mt[[j.for.mt]],n.mt,the,B.tuck)), 
                           method = "L-BFGS-B", lower=lower.th, upper=upper.th)$par
    }else{
      hyper.mt.ucb = hyper.mt.ucb
    }
    
    like.re.mt[[j.for.mt]][[i.mt+1]] = likeli.mt(x0.mt[[j.for.mt]],
                                                 x0.mt[[j.for.mt]],y0.mt[[j.for.mt]],ind0.mt[[j.for.mt]],
                                                 n.mt,dim.h,hyper.mt.ucb,B.tuck)
    hyper.mt[[j.for.mt]][[i.mt+1]] = like.re.mt[[j.for.mt]][[i.mt+1]]$the0
    print(i.mt)
  }
  
  mtgp.ucb <- function(x.new,ind.new) mtgp.hat(x.new,ind.new,x0.mt[[j.for.mt]],y0.mt[[j.for.mt]],ind0.mt[[j.for.mt]],
                                               n.mt,n.test=1,dim.h,hyper.mt[[j.for.mt]][[i.mt+1]],B.tuck) 
  mtgp.bo[[j.for.mt]] = mtgp.ucb
  
  h.mt[[j.for.mt]] = apply(y0.mt[[j.for.mt]],2,h)
  regret.mt[[j.for.mt]] = h.star-h.mt[[j.for.mt]]
  
  tab.ind.mt[[j.for.mt]] = unlist(lapply(ind0.mt[[j.for.mt]],
                                         function(a) sum(apply(a, 1, function(row) any(duplicated(rbind(row, ind.star)))))))
  
  layout(matrix(1, nrow = 1, ncol = 1))
  plot(rep(h.star,(n.mt-n+1)),type="b",lwd=3,lty=1,pch=1,col=1,ylim=c(cummax(h.mt[[j.for.mt]])[n],h.star))
  lines(cummax(h.mt[[j.for.mt]])[n:n.mt],type="b",lwd=3,lty=2,pch=2,col=2)
  
  ins.regret.mt[[j.for.mt]] = h.star-cummax(h.mt[[j.for.mt]][(n+1):n.mt])
  cum.regret.mt[[j.for.mt]] = cumsum(ins.regret.mt[[j.for.mt]])
  
  plot(cumsum(ins.regret.mt[[j.for.mt]]),type="b",lwd=3,lty=2,pch=2,col=2)
  
  tab.ind.mt[[j.for.mt]][which.max(h.mt[[j.for.mt]])]
  print(j.for.mt)
}


# mt.star = bobyqa(x0.mt[[j.for.mt]][which.min(h.mt[[j.for.mt]]),], 
#                  function(x.new) -sum(B.tuck%*%mtgp.bo[[j.for.mt]](x.new)$mean.tuck),
#                  lower=lower.x, upper=upper.x)
# x.star = mt.star$par
# y.star = sum(B.tuck%*%mtgp.bo[[j.for.mt]](x.star)$mean.tuck)
# round(x.star,4); round(y.star,4)


mat <- do.call(rbind, cum.regret.mt)
cum.regret.mean <- apply(mat,2, mean)
cum.regret.lower <- apply(mat,2, function(x) quantile(x, 0.025))
cum.regret.upper <- apply(mat,2, function(x) quantile(x, 0.975))


time <- 1:m
plot(time, cum.regret.mean, type = "l", lwd = 2, col = "blue", ylim = range(c(cum.regret.lower, cum.regret.upper)),
     ylab = "Value", xlab = "Time", main = "Mean with 95% Confidence Band")
polygon(c(time, rev(time)),
        c(cum.regret.upper, rev(cum.regret.lower)),
        col = rgb(0.1, 0.2, 0.9, 0.2), border = NA)
lines(time, cum.regret.mean, col = "blue", lwd = 2)


pmt.ucb.list = list(ind.x.star=ind.x.star, h.star=h.star, ind.star=ind.star, ora.x.star=ora.x.star,         
                    like.re.mt=like.re.mt, hyper.mt=hyper.mt, fhat=fhat,
                    x0.mt=x0.mt, y0.mt=y0.mt, mtgp.bo=mtgp.bo, 
                    h.mt=h.mt, regret.mt=regret.mt, ins.regret.mt=ins.regret.mt, cum.regret.mt=cum.regret.mt,
                    ind.x.mt=ind.x.mt, ind0.mt=ind0.mt, tab.ind.mt=tab.ind.mt,
                    beta.mt=beta.mt, alpha.mt=alpha.mt, ucb.new.mt=ucb.new.mt)
save(pmt.ucb.list, file="c1.pmt.ucb.list.RData")








